import pandas as pd  
from sklearn.preprocessing import LabelEncoder 
import pickle 
  
# Load the dataset  
credit_customers = pd.read_csv("credit_customers.csv")
  
# Create a copy of the stable_employment DataFrame  
stable_employment_encoded = stable_employment.copy()  
  
# Initialize the label encoder  
encoder = LabelEncoder()  
  
# Convert non-numeric columns to numeric values using label encoding  
for column in stable_employment_encoded.columns:  
    if stable_employment_encoded[column].dtype == 'object':  
        stable_employment_encoded[column] = encoder.fit_transform(stable_employment_encoded[column])  
  
# Calculate the correlation matrix for the encoded dataset  
correlation_matrix = stable_employment_encoded.corr()  
  
# Print the correlation matrix  
print("Correlation matrix:\n", correlation_matrix)  
pickle.dump(correlation_matrix,open("./ref_result/correlation_matrix.pkl","wb"))
 
# Analyze the relationships between variables  
credit_history_duration_relationship = stable_employment.groupby('credit_history')['duration'].mean()  
employment_duration_relationship = stable_employment.groupby('employment')['duration'].mean()  
  
# Print the relationships between variables  
print("\nRelationship between credit history and loan duration:\n", credit_history_duration_relationship)  
pickle.dump(credit_history_duration_relationship,open("./ref_result/credit_history_duration_relationship.pkl","wb"))
print("\nRelationship between employment status and loan duration:\n", employment_duration_relationship)  
pickle.dump(employment_duration_relationship,open("./ref_result/employment_duration_relationship.pkl","wb"))
  
# Note: You may want to further explore the relationships between other variables or visualize the data using plots to gain more insights. 



